/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.jobs.model.Profession;

public class JobCollection {
    private final JobState collectionJobState;
    private Map<Profession, Map<Long, Job>> byProfession = new ConcurrentHashMap<Profession, Map<Long, Job>>();
    private Map<Long, Job> byId = new ConcurrentHashMap<Long, Job>();
    private int iterationCursor = 0;
    private List<Job> iterableCollection = emptyList;
    private static final List<Job> emptyList = new ArrayList<Job>();

    public JobCollection(JobState jobState, ProfessionDictionary professionDictionary) {
        this.collectionJobState = jobState;
        for (Profession profession : professionDictionary.getAll()) {
            this.byProfession.put(profession, new ConcurrentHashMap());
        }
        this.byProfession.put(ProfessionDictionary.NULL_PROFESSION, new ConcurrentHashMap());
    }

    public Map<Long, Job> getByProfession(Profession profession) {
        return this.byProfession.get(profession);
    }

    public Job next() {
        if (this.iterationCursor >= this.iterableCollection.size()) {
            this.iterableCollection = this.byId.size() > 0 ? new ArrayList<Job>(this.byId.values()) : emptyList;
            this.iterationCursor = 0;
        }
        if (this.iterableCollection.isEmpty()) {
            return null;
        }
        Job job = this.iterableCollection.get(this.iterationCursor);
        ++this.iterationCursor;
        return job;
    }

    public void add(Job job) {
        job.setJobState(this.collectionJobState);
        this.byProfession.get(job.getRequiredProfession()).put(job.getJobId(), job);
        this.byId.put(job.getJobId(), job);
    }

    public void remove(Job jobToRemove) {
        this.byProfession.get(jobToRemove.getRequiredProfession()).remove(jobToRemove.getJobId());
        this.byId.remove(jobToRemove.getJobId());
    }

    public int size() {
        return this.byId.size();
    }
}

